import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 5))

# Define the properties of the tiles
tiles = [
    {'id': 'tile_0-0', 'pos': (0, 3), 'color': 'black', 'status': 'painted black'},
    {'id': 'tile_0-1', 'pos': (2, 3), 'color': 'white', 'status': 'painted white'},
    {'id': 'tile_0-2', 'pos': (4, 3), 'color': 'black', 'status': 'painted black'},
    {'id': 'tile_0-3', 'pos': (6, 3), 'color': 'white', 'status': 'painted white'},
    {'id': 'tile_0-4', 'pos': (8, 3), 'color': 'black', 'status': 'painted black'},
    {'id': 'tile_1-0', 'pos': (0, 0), 'color': 'lightgrey', 'status': 'not painted'},
    {'id': 'tile_1-1', 'pos': (2, 0), 'color': 'lightgrey', 'status': 'not painted'},
    {'id': 'tile_1-2', 'pos': (4, 0), 'color': 'lightgrey', 'status': 'not painted'},
    {'id': 'tile_1-3', 'pos': (6, 0), 'color': 'lightgrey', 'status': 'not painted'},
    {'id': 'tile_1-4', 'pos': (8, 0), 'color': 'lightgrey', 'status': 'not painted'},
]

# Add tiles to the plot
for tile in tiles:
    rect = patches.Rectangle(tile['pos'], 2, 3, linewidth=1, edgecolor='black', facecolor=tile['color'])
    ax.add_patch(rect)
    ax.text(tile['pos'][0] + 0.1, tile['pos'][1] + 2.5, tile['id'], fontsize=6, verticalalignment='center', color='black')
    ax.text(tile['pos'][0] + 0.1, tile['pos'][1] + 1.5, tile['status'], fontsize=6, verticalalignment='center', color='black')

# Add robot text at the bottom
ax.text(0, -1, 'robot1', fontsize=8, verticalalignment='center', color='black')
ax.text(2, -1, 'holding no constraints', fontsize=8, verticalalignment='center', color='black')

# Set limits and aspect
ax.set_xlim(-1, 11)
ax.set_ylim(-2, 7)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('tiles_instance_3/state_9999/attempts/diagram_attempts/diagram_attempt_3.png', bbox_inches='tight')
plt.close()